#!/usr/bin/env python
#-*- coding:utf-8 –*-
#-----------------------------------------------------------------------------
# The short script is a example that open a socket, sends a query,
# print the return message and closes the socket.
#
#No warranties expressed or implied
#
#SIGLENT/JAC 05.2018
#
#-----------------------------------------------------------------------------
import socket # for sockets
import sys # for exit
import time # for sleep
#-----------------------------------------------------------------------------

remote_ip = "192.168.55.116" # should match the instrument’s IP address
port = 5025 # the port number of the instrument service

#Port 5024 is valid for the following:
#SIGLENT SDS1202X-E, SDG1/2X Series, SDG6X Series
#SDM3055, SDM3045X, and SDM3065X 
#
#Port 5025 is valid for the following:
#SIGLENT SVA1000X series, SSA3000X Series, and SPD3303X/XE

count = 0

def SocketConnect():
    try:
        #create an AF_INET, STREAM socket (TCP)
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    except socket.error:
        print ('Failed to create socket.')
        sys.exit();
    try:
        #Connect to remote server
        s.connect((remote_ip , port))
    except socket.error:
        print ('failed to connect to ip ' + remote_ip)
    return s

def SocketClose(Sock):
    #close the socket
    Sock.close()
    time.sleep(1)

def main():
    global remote_ip
    global port
    global count

    # Body: send the SCPI commands *IDN? 10 times and print the return message
    s = SocketConnect()
    for i in range(1):
        s.sendall(b'OUTPUT CH1,ON')
        #s.sendall(b'\n')
        time.sleep(5)
        s.sendall(b'OUTPUT CH1,OFF')
        #s.sendall(b'\n')
        time.sleep(5)             
        print (str(count))
        count = count + 1
    SocketClose(s)
    print('Test complete. Exiting program')
    sys.exit

if __name__ == '__main__':
    proc = main()
