%   Example:
%       SDG_matlab_example;

%% Instrument Connection
% Find a VISA-USB object.
 obj1 = visa('Agilent', 'USB0::0xF4EC::0x1101::SDG6XEBC5R0143::INSTR');
%'TCPIP0::10.11.21.70::inst0::INSTR'

% Configure instrument object, obj1, to Input and Output Buffer Size
set(obj1, 'InputBufferSize', 20480000);
set(obj1, 'OutputBufferSize', 20480000);
%set(obj1, 'ValuesReceived', 2048000)
set(obj1, 'Timeout', 10);
% Connect to instrument object, obj1.
fopen(obj1);
wave_points = {'8000','8000', 'c0fa', 'c0fa', '0000', '0000', '3f06', '3f06', '7fff', '7fff'};
f = fopen('wave2.bin', 'wb');
len = length(wave_points);
data = zeros(1,len);
for i = 1:len
    a = uint16(hex2dec(wave_points(i)));
    data(i) = a;
end
s = uint16(data);
fwrite(f, s, 'uint16');
fclose(f);
f = fopen('wave2.bin', 'rb');
%data = fread(f,[1,len]);
data = fread(f);
%visa_string = sprintf('C1:WVDT:BLOCK #281,WVNM,wave1,FREQ,2000.0,AMPL,4.0,OFST,0.0,PHASE,0.0,WAVEDATA,%s',data);
visa_string = sprintf('C1:WVDT WVNM,wave2,FREQ,2000.0,AMPL,4.0,OFST,0.0,PHASE,0.0,WAVEDATA,%s',data);
fwrite(obj1,visa_string);
fwrite(obj1,'C1:ARWV NAME,wave2');
fwrite(obj1,'C1:OUTP OFF');
fwrite(obj1,'C1:OUTP ON')
fclose(f);
% Disconnect all objects.
fclose(obj1);
% Clean up all objects.
delete(obj1);
clear obj1;